#! bash oh-my-bash.module
function _pj {
  [ -z "$PROJECT_PATHS" ] && return
  shift
  [ "$1" == "open" ] && shift

  local cur prev words cword
  _init_completion || return

  local IFS=$'\n' i j k

  compopt -o filenames

  local -r mark_dirs=$(_rl_enabled mark-directories && echo y)
  local -r mark_symdirs=$(_rl_enabled mark-symlinked-directories && echo y)

  for i in ${PROJECT_PATHS//:/$'\n'}; do
    # create an array of matched subdirs
    k="${#COMPREPLY[@]}"
    for j in $( compgen -d $i/$cur ); do
      if [[ ( $mark_symdirs && -h $j || $mark_dirs && ! -h $j ) && ! -d ${j#$i/} ]]; then
        j+="/"
      fi
      COMPREPLY[k++]=${j#$i/}
    done
  done

  if [[ ${#COMPREPLY[@]} -eq 1 ]]; then
    i=${COMPREPLY[0]}
    if [[ "$i" == "$cur" && $i != "*/" ]]; then
      COMPREPLY[0]="${i}/"
    fi
  fi

  return 0
}

complete -F _pj -o nospace pj
complete -F _pj -o nospace pjo

