# u-boot-update

A simple U-Boot configuration tool for BredOS.

## Features

- Automatic U-Boot configuration generation
- Kernel auto-detection (both `vmlinuz-*` and `Image.gz` formats)
- Device Tree Binary (DTB) management
- DTB overlay support
- Package-specific DTB organization
- LUKS encryption support
- Recovery boot entries with fallback initramfs

## Installation

Install from the BredOS repos:

```bash
sudo pacman -S u-boot-update
```

Or install from source:

```bash
git clone https://github.com/BredOS/u-boot-update.git
cd u-boot-update
makepkg -si
```

## Configuration

Edit the configuration file at `/etc/default/u-boot`:

```bash
# Enable u-boot-update
U_BOOT_IS_SETUP="true"

# Specify your DTB file
U_BOOT_FDT="your-device.dtb"

# Add additional kernel parameters as needed
U_BOOT_PARAMETERS="console=ttyS0,115200 quiet splash"
```

## Usage

Enable and configure the tool:

1. Edit `/etc/default/u-boot` and set `U_BOOT_IS_SETUP="true"`
2. Set the correct DTB file with `U_BOOT_FDT="your-device.dtb"`
3. Run `sudo u-boot-update` to generate the configuration


## License

GPL-3.0
