# List of Third-Party Libaries

This folder contains all third-party libraries used by BTstack. The following table lists their source, license type, and what it is used for.

Library                                                                                                         | Version  | License       | Used             | Notes
----------------------------------------------------------------------------------------------------------------|----------|---------------|------------------|----------
[Android SBC Codec](https://android.googlesource.com/platform/external/bluetooth/bluedroid/+/master/embdrv/sbc) | e8c3d75b | Apache 2.0    | HFP WBS, A2DP    | optimized audio codec
[hxcmod-player](https://github.com/jfdelnero/HxCModPlayer)                                                      | f57bc0fd | Public Domain | A2DP Source Demo | mod music player
[Google LC3 Codec](https://github.com/google/liblc3.git)						                                | bb85f7dd | Apache 2.0    | LE Audio         | audio codec
[lwIP](http://savannah.nongnu.org/projects/lwip/)                                                               | b3a93941 | BSD 3-Clause  | PAN Demo         | complete network stack
[md5](http://openwall.info/wiki/people/solar/software/public-domain-source-code/md5)                            | 1.0      | Public Domain | PBAP             | cryptographic hash function
[micro-ecc](https://github.com/kmackay/micro-ecc)                                                               | e4d264b5 | BSD 2-Clause  | LE SC, Mesh      | elliptic-curve library
[Rijndael Encryption Algorithm](http://www.efgh.com/software/rijndael.htm)                                      | 20020903 | Public Domain | BTstack Crypto   | optional AES128 software implementation  
[segger-rtt](https://www.segger.com/products/debug-probes/j-link/technology/about-real-time-transfer/)          | V786a    | BSD 3-Clause  | HCI PacketLog    | high-speed logging with SEGGER J-Link debug probes (development)
[tinydir](https://github.com/cxong/tinydir)                                                                     | 1.2.6    | BSD 2-Clause  | GAP Bonding      | get a directory listing on POSIX + Windwows systems
[Yxml](https://dev.yorhel.nl/yxml)                                                                              | 10f968b0 | MIT           | PBAP             | minimal stream XML parser
    
