"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Icon = void 0;
var _upngJs = require("upng-js");
/**
 * Icon object.
 */
class Icon {
  /**
   * Icon constructor.
   */
  constructor() {}

  /**
   * Decode PNG data to RGBA image.
   *
   * @param data PNG data.
   * @returns Image data.
   */
  _decodePngToRgba(data) {
    const image = _upngJs.decode(data);
    return {
      width: image.width,
      height: image.height,
      data: new Uint8Array(_upngJs.toRGBA8(image)[0])
    };
  }

  /**
   * Encode RGBA image to PNG data.
   *
   * @param imageData Image data.
   * @returns PNG data.
   */
  _encodeRgbaToPng(imageData) {
    return Buffer.from(_upngJs.encode([imageData.data.buffer], imageData.width, imageData.height, 0, [], true));
  }

  /**
   * Encode icon.
   *
   * @returns Encoded icon.
   */
}
exports.Icon = Icon;
//# sourceMappingURL=icon.js.map
