"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _intro = _interopRequireDefault(require("intro.js"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = require("react");
var introJsPropTypes = _interopRequireWildcard(require("../../helpers/proptypes.cjs"));
var introJsDefaultProps = _interopRequireWildcard(require("../../helpers/defaultProps.cjs"));
var _server = require("../../helpers/server.cjs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 * Intro.js Hints Component.
 */
class Hints extends _react.Component {
  /**
   * React Props
   * @type {Object}
   */
  static propTypes = {
    enabled: _propTypes.default.bool,
    hints: _propTypes.default.arrayOf(_propTypes.default.shape({
      element: _propTypes.default.string.isRequired,
      hint: _propTypes.default.string.isRequired,
      hintPosition: introJsPropTypes.hintPosition
    })).isRequired,
    onClick: _propTypes.default.func,
    onClose: _propTypes.default.func,
    options: introJsPropTypes.options
  };

  /**
   * React Default Props
   * @type {Object}
   */
  static defaultProps = {
    enabled: false,
    onClick: null,
    onClose: null,
    options: introJsDefaultProps.options
  };

  /**
   * Creates a new instance of the component.
   * @class
   * @param {Object} props - The props of the component.
   */
  constructor(props) {
    super(props);
    this.introJs = null;
    this.isConfigured = false;
    this.installIntroJs();
  }

  /**
   * Lifecycle: componentDidMount.
   * We use this event to enable Intro.js hints at mount time if enabled right from the start.
   */
  componentDidMount() {
    if (this.props.enabled) {
      this.configureIntroJs();
      this.renderHints();
    }
  }

  /**
   * Lifecycle: componentDidUpdate.
   * @param  {Object} prevProps - The previous props.
   */
  componentDidUpdate(prevProps) {
    const {
      enabled,
      hints,
      options
    } = this.props;
    if (!this.isConfigured || prevProps.hints !== hints || prevProps.options !== options) {
      this.configureIntroJs();
      this.renderHints();
    }
    if (prevProps.enabled !== enabled) {
      this.renderHints();
    }
  }

  /**
   * Lifecycle: componentWillUnmount.
   * We use this even to hide the hints when the component is unmounted.
   */
  componentWillUnmount() {
    this.introJs.hideHints();
  }

  /**
   * Installs Intro.js.
   */
  installIntroJs() {
    if ((0, _server.isServer)()) {
      return;
    }
    this.introJs = (0, _intro.default)();
    const {
      onClick,
      onClose
    } = this.props;
    if (onClick) {
      this.introJs.onhintclick(onClick);
    }
    if (onClose) {
      this.introJs.onhintclose(onClose);
    }
  }

  /**
   * Configures Intro.js if not already configured.
   */
  configureIntroJs() {
    const {
      options,
      hints
    } = this.props;

    // We need to remove all hints otherwise new hints won't be added.
    this.introJs.removeHints();
    this.introJs.setOptions({
      ...options,
      hints
    });
    this.isConfigured = true;
  }

  /**
   * Renders the Intro.js hints.
   */
  renderHints() {
    const {
      enabled,
      hints
    } = this.props;
    if (enabled && hints.length > 0) {
      this.introJs.showHints();
    } else if (!enabled) {
      this.introJs.hideHints();
    }
  }

  /**
   * Renders the component.
   * @return {null} We do not want to render anything.
   */
  render() {
    return null;
  }
}
exports.default = Hints;