/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */

#ifndef _DT_BINDINGS_CLK_ROCKCHIP_RK1808_H
#define _DT_BINDINGS_CLK_ROCKCHIP_RK1808_H

/* core clocks */
#define PLL_APLL		1
#define PLL_DPLL		2
#define PLL_CPLL		3
#define PLL_GPLL		4
#define PLL_NPLL		5
#define PLL_PPLL		6
#define ARMCLK			7

#define DCLK_VOPRAW		10
#define DCLK_VOPLITE		11
#define DCLK_CIF		12
#define XIN24M_DIV		13

/* sclk (special clocks) */
#define USB480M			20
#define SCLK_PVTM_CORE		21
#define SCLK_NPU		22
#define SCLK_PVTM_NPU		23
#define SCLK_DDRCLK		24
#define SCLK_I2S0_8CH_TX_MUX	25
#define SCLK_I2S0_8CH_RX_MUX	26
#define SCLK_RTC32K_PMU		27
#define SCLK_TXESC		28
#define SCLK_RGA		29
#define SCLK_ISP		30
#define SCLK_CIF_OUT		31
#define SCLK_PCIE_AUX		32
#define SCLK_USB3_OTG0_REF	33
#define SCLK_USB3_OTG0_SUSPEND	34
#define SCLK_SDIO_DIV		35
#define SCLK_SDIO_DIV50		36
#define SCLK_SDIO		37
#define SCLK_SDIO_DRV		38
#define SCLK_SDIO_SAMPLE	39
#define SCLK_EMMC_DIV		40
#define SCLK_EMMC_DIV50		41
#define SCLK_EMMC		42
#define SCLK_EMMC_DRV		43
#define SCLK_EMMC_SAMPLE	44
#define SCLK_SDMMC_DIV		45
#define SCLK_SDMMC_DIV50	46
#define SCLK_SDMMC		47
#define SCLK_SDMMC_DRV		48
#define SCLK_SDMMC_SAMPLE	49
#define SCLK_SFC		50
#define SCLK_GMAC_OUT		51
#define SCLK_GMAC_SRC		52
#define SCLK_GMAC		53
#define SCLK_GMAC_REF		54
#define SCLK_GMAC_REFOUT	55
#define SCLK_GMAC_RGMII_SPEED	56
#define SCLK_GMAC_RMII_SPEED	57
#define SCLK_GMAC_RX_TX		58
#define SCLK_CRYPTO		59
#define SCLK_CRYPTO_APK		60
#define SCLK_UART1		61
#define SCLK_UART2		62
#define SCLK_UART3		63
#define SCLK_UART4		64
#define SCLK_UART5		65
#define SCLK_UART6		66
#define SCLK_UART7		67
#define SCLK_I2C1		68
#define SCLK_I2C2		69
#define SCLK_I2C3		70
#define SCLK_I2C4		71
#define SCLK_I2C5		72
#define SCLK_SPI0		73
#define SCLK_SPI1		74
#define SCLK_SPI2		75
#define SCLK_TSADC		76
#define SCLK_SARADC		77
#define SCLK_EFUSE_S		78
#define SCLK_EFUSE_NS		79
#define DBCLK_GPIO1		80
#define DBCLK_GPIO2		81
#define DBCLK_GPIO3		82
#define DBCLK_GPIO4		83
#define SCLK_PWM0		84
#define SCLK_PWM1		85
#define SCLK_PWM2		86
#define SCLK_TIMER0		87
#define SCLK_TIMER1		88
#define SCLK_TIMER2		89
#define SCLK_TIMER3		90
#define SCLK_TIMER4		91
#define SCLK_TIMER5		92
#define SCLK_PDM		93
#define SCLK_I2S0_8CH_TX_SRC	94
#define SCLK_I2S0_8CH_TX	95
#define SCLK_I2S0_8CH_TX_OUT	96
#define SCLK_I2S0_8CH_RX_SRC	97
#define SCLK_I2S0_8CH_RX	98
#define SCLK_I2S0_8CH_RX_OUT	99
#define SCLK_I2S1_2CH_SRC	100
#define SCLK_I2S1_2CH		101
#define SCLK_I2S1_2CH_OUT	102
#define SCLK_WIFI_PMU		103
#define SCLK_UART0_PMU		104
#define SCLK_PVTM_PMU		105
#define SCLK_PMU_I2C0		106
#define DBCLK_PMU_GPIO0		107
#define SCLK_REF24M_PMU		108
#define SCLK_USBPHY_REF		109
#define SCLK_MIPIDSIPHY_REF	110
#define SCLK_PCIEPHY_REF	111
#define SCLK_RTC32K_FRAC	112
#define SCLK_32K_IOE		113

/* aclk gates */
#define ACLK_GIC_PRE		145
#define ACLK_GIC		146
#define ACLK_VPU		147
#define ACLK_NPU		148
#define ACLK_IMEM_PRE		153
#define ACLK_IMEM0		154
#define ACLK_IMEM1		155
#define ACLK_IMEM2		156
#define ACLK_IMEM3		157
#define HSCLK_VIO		158
#define ACLK_VOPRAW		159
#define ACLK_VOPLITE		160
#define ACLK_RGA		161
#define ACLK_ISP		162
#define ACLK_CIF		163
#define HSCLK_PCIE		164
#define ACLK_USB3OTG		165
#define ACLK_PCIE		166
#define ACLK_PCIE_MST		167
#define ACLK_PCIE_SLV		168
#define MSCLK_PERI		169
#define ACLK_GMAC		170
#define HSCLK_BUS_PRE		171
#define ACLK_CRYPTO		172
#define ACLK_DCF		173
#define ACLK_DMAC		174

/* hclk gates */
#define HCLK_NPU		199
#define HCLK_VPU		200
#define LSCLK_VIO		201
#define HCLK_VOPRAW		202
#define HCLK_VOPLITE		203
#define HCLK_RGA		204
#define HCLK_ISP		205
#define LSCLK_PCIE		206
#define HCLK_HOST		207
#define LSCLK_PERI		208
#define HCLK_SDIO		209
#define HCLK_EMMC		210
#define HCLK_SDMMC		211
#define HCLK_SFC		212
#define MSCLK_BUS_PRE		213
#define HCLK_ROM		214
#define HCLK_CRYPTO		215
#define HCLK_VAD		216
#define HCLK_PDM		217
#define HCLK_I2S0_8CH		218
#define HCLK_I2S1_2CH		219
#define MSCLK_CORE_NIU		220
#define HSCLK_IMEM		221
#define HCLK_HOST_ARB		222
#define HCLK_CIF		223

/* pclk gates */
#define PCLK_DDR		250
#define PCLK_DSI_TX		251
#define PCLK_CSI_TX		252
#define PCLK_CSI2HOST		253
#define PCLK_PCIE		254
#define PCLK_GMAC		255
#define LSCLK_BUS_PRE		256
#define PCLK_DCF		257
#define PCLK_UART1		258
#define PCLK_UART2		259
#define PCLK_UART3		260
#define PCLK_UART4		261
#define PCLK_UART5		262
#define PCLK_UART6		263
#define PCLK_UART7		264
#define PCLK_I2C1		265
#define PCLK_I2C2		266
#define PCLK_I2C3		267
#define PCLK_I2C4		268
#define PCLK_I2C5		269
#define PCLK_SPI0		270
#define PCLK_SPI1		271
#define PCLK_SPI2		272
#define PCLK_TSADC		273
#define PCLK_SARADC		274
#define PCLK_EFUSE		275
#define PCLK_GPIO1		276
#define PCLK_GPIO2		277
#define PCLK_GPIO3		278
#define PCLK_GPIO4		279
#define PCLK_PWM0		280
#define PCLK_PWM1		281
#define PCLK_PWM2		282
#define PCLK_TIMER		283
#define PCLK_WDT		284
#define PCLK_MIPIDSIPHY		285
#define PCLK_MIPICSIPHY		286
#define PCLK_DDRMON		287
#define PCLK_DDRC		289
#define PCLK_MSCH		290
#define PCLK_STDBY		291
#define PCLK_GPIO0_PMU		292
#define PCLK_UART0_PMU		293
#define PCLK_I2C0_PMU		294
#define PCLK_USB3PHY_PIPE	295
#define PCLK_PMU_PRE		296

#define CLK_NR_CLKS		(PCLK_PMU_PRE + 1)

/* soft-reset indices */

/* cru_softrst_con0 */
#define SRST_CORE0_PO		0
#define SRST_CORE1_PO		1
#define SRST_CORE0		2
#define SRST_CORE1		3
#define SRST_CORE0_DBG		4
#define SRST_CORE1_DBG		5
#define SRST_TOPDBG		6
#define SRST_CORE_NOC		7
#define SRST_STRC_A		8
#define SRST_L2C		9
#define SRST_DAP                10
#define SRST_CORE_MSNIU		11
#define SRST_GIC2CORE		12
#define SRST_CORE2GIC		13
#define SRST_CORE_PRF_A		14
#define SRST_CORE_GRF_P		15

/* cru_softrst_con1 */
#define SRST_DDRPHY		16
#define SRST_DDRPHY_P		18
#define SRST_UPCTL2		20
#define SRST_UPCTL2_A		21
#define SRST_UPCTL2_P		22
#define SRST_MSCH		23
#define SRST_MSCH_P		24
#define SRST_DDRMON_P		25
#define SRST_DDRSTDBY_P		26
#define SRST_DDRSTDBY		27
#define SRST_DDRGRF_P		28
#define SRST_AXI_SPLIT_A	29
#define SRST_DDRDFI_CTL		30
#define SRST_DDRDFI_CTL_P	31

/* cru_softrst_con2 */
#define SRST_GIC500_NIU_A	32
#define SRST_GIC500_A		33
#define SRST_GIC_CORE2GIC	34
#define SRST_GIC_GIC2CORE	35
#define SRST_NPU_CORE		36
#define SRST_NPU_A		37
#define SRST_NPU_H		38
#define SRST_NPU_NIU_A		39
#define SRST_NPU_NIU_H		40
#define SRST_NPU2MEM_A		41
#define SRST_NPU_PVTM		42
#define SRST_CORE_PVTM		43
#define SRST_GIC_SPINLOCK_A	47

/* cru_softrst_con3 */
#define SRST_PCIE_NIU_H		48
#define SRST_PCIE_NIU_L		49
#define SRST_PCIEGRF_P		50
#define SRST_PCIECTL_P		51
#define SRST_PCIECTL_POWERUP	52
#define SRST_PCIECTL_MST_A	53
#define SRST_PCIECTL_SLV_A	54
#define SRST_PCIECTL_DBI_A	55
#define SRST_PCIECTL_BUTTON	56
#define SRST_PCIECTL_PE		57
#define SRST_PCIECTL_CORE	58
#define SRST_PCIECTL_NSTICKY	59
#define SRST_PCIECTL_STICKY	60
#define SRST_PCIECTL_PWR	61
#define SRST_PCIE_NIU_A		62
#define SRST_PCIE_NIU_P		63

/* cru_softrst_con4 */
#define SRST_PCIEPHY_POR	64
#define SRST_PCIEPHY_P		65
#define SRST_PCIEPHY_PIPE	66
#define SRST_USBPHY_POR		67
#define SRST_USBPHY_OTG_PORT	68
#define SRST_USBPHY_HOST_PORT	69
#define SRST_USB3PHY_GRF_P	70
#define SRST_USB2PHY_GRF_P	71
#define SRST_USB3_OTG_A		72
#define SRST_USB2HOST_H		73
#define SRST_USB2HOST_ARB_H	74
#define SRSTUSB2HOST_UTMI	75

/* cru_softrst_con5 */
#define SRST_IMEM0_A		80
#define SRST_IMEM1_A		81
#define SRST_IMEM2_A		82
#define SRST_IMEM3_A		83
#define SRST_IMEM0_NIU_A	84
#define SRST_IMEM1_NIU_A	85
#define SRST_IMEM2_NIU_A	86
#define SRST_IMEM3_NIU_A	87
#define SRST_IMEM_NIU_H		88
#define SRST_VPU_NIU_A		92
#define SRST_VPU_NIU_H		93
#define SRST_VPU_A		94
#define SRST_VPU_H		95

/* cru_softrst_con6 */
#define SRST_VIO_NIU_H		96
#define SRST_VIO_NIU_L		97
#define SRST_VOPRAW_A		98
#define SRST_VOPRAW_H		99
#define SRST_VOPRAW_D		100
#define SRST_VOPLITE_A		101
#define SRST_VOPLITE_H		102
#define SRST_VOPLITE_D		103
#define SRST_MIPIDSI_HOST_P	104
#define SRST_CSITX_P		105
#define SRST_CSITX_TXBYTEHS	106
#define SRST_CSITX_TXESC	107
#define SRST_CSITX_CAM		108
#define SRST_CSITX_I		109

/* cru_softrst_con7 */
#define SRST_RGA_A		112
#define SRST_RGA_H		113
#define SRST_RGA		114
#define SRST_CSI2HOST_P		115
#define SRST_CIF_A		116
#define SRST_CIF_H		117
#define SRST_CIF_I		118
#define SRST_CIF_PCLKIN		119
#define SRST_CIF_D		120
#define SRST_ISP_H		121
#define SRST_ISP		122
#define SRST_MIPICSIPHY_P	124
#define SRST_MIPIDSIPHY_P	125

/* cru_softrst_con8 */
#define SRST_PERI_NIU_H		128
#define SRST_PERI_NIU_L		129
#define SRST_PDMMC_NIU_H	132
#define SRST_SDMMC_H		133
#define SRST_SDIO_H		134
#define SRST_EMMC_H		135
#define SRST_SFC_H		136
#define SRST_SFC		137
#define SRST_GMAC_NIU_A		140
#define SRST_GMAC_NIU_H		141
#define SRST_GMAC_NIU_P		142
#define SRST_GAMC_A		143

/* cru_softrst_con9 */
#define SRST_PMU_NIU_P		144
#define SRST_PMU_SGRF_P		145
#define SRST_PMU_GRF_P		146
#define SRST_PMU_PMU		147
#define SRST_PMU_MEM_P		148
#define SRST_PMU_GPIO0_P	149
#define SRST_PMU_UART0_P	150
#define SRST_PMU_CRU		151
#define SRST_PMU_PVTM		152
#define SRST_PMU_UART0		153
#define SRST_PMU_NIU_H		154
#define SRST_PMU_DDR_FAIL_SAVE	155
#define SRST_PMU_I2C0_P		156
#define SRST_PMU_I2C0		157
#define SRST_PMU_GPIO0_DB	158

/* cru_softrst_con10 */
#define SRST_AUDIO_NIU_H	160
#define SRST_VAD_H		161
#define SRST_PDM_H		162
#define SRST_PDM		163
#define SRST_I2S0_H		164
#define SRST_I2S0_TX		165
#define SRST_I2S1_H		166
#define SRST_I2S1		167
#define SRST_I2S0_RX		168

/* cru_softrst_con11 */
#define SRST_BUS_NIU_M		176
#define SRST_BUS_NIU_L		177
#define SRST_TOP_NIU_P		178
#define SRST_ROM_H		179
#define SRST_CRYPTO_A		180
#define SRST_CRYPTO_H		181
#define SRST_CRYPTO_CORE	182
#define SRST_CRYPTO_APK		183
#define SRST_DCF_A		184
#define SRST_DCF_P		185
#define SRST_UART1_P		186
#define SRST_UART1		187
#define SRST_UART2_P		188
#define SRST_UART2		189
#define SRST_UART3_P		190
#define SRST_UART3		191

/* cru_softrst_con12 */
#define SRST_UART4_P		192
#define SRST_UART4		193
#define SRST_UART5_P		194
#define SRST_UART5		195
#define SRST_UART6_P		196
#define SRST_UART6		197
#define SRST_UART7_P		198
#define SRST_UART7		199
#define SRST_I2C1_P		200
#define SRST_I2C1		201
#define SRST_I2C2_P		202
#define SRST_I2C2		203
#define SRST_I2C3_P		204
#define SRST_I2C3		205
#define SRST_PWM0_P		206
#define SRST_PWM0		207

/* cru_softrst_con13 */
#define SRST_PWM1_P		208
#define SRST_PWM1		209
#define SRST_PWM2_P		210
#define SRST_PWM2		211
#define SRST_SPI0_P		212
#define SRST_SPI0		213
#define SRST_SPI1_P		214
#define SRST_SPI1		215
#define SRST_SPI2_P		216
#define SRST_SPI2		217
#define SRST_BUS_SGRF_P		218
#define SRST_BUS_GRF_P		219
#define SRST_TIMER_P		220
#define SRST_TIMER0		221
#define SRST_TIMER1		222
#define SRST_TIMER2		223

/* cru_softrst_con14 */
#define SRST_TIMER3		224
#define SRST_TIMER4		225
#define SRST_TIMER5		226
#define SRST_WDT_NS_P		227
#define SRST_EFUSE_NS_P		228
#define SRST_EFUSE_NS		229
#define SRST_GPIO1_P		230
#define SRST_GPIO1_DB		231
#define SRST_GPIO2_P		232
#define SRST_GPIO2_DB		233
#define SRST_GPIO3_P		234
#define SRST_GPIO3_DB		235
#define SRST_GPIO4_P		236
#define SRST_GPIO4_DB		237
#define SRST_BUS_SUB_NIU_M	238

/* cru_softrst_con15 */
#define SRST_I2C4_P		240
#define SRST_I2C4		241
#define SRST_I2C5_P		242
#define SRST_I2C5		243
#define SRST_SARADC		252
#define SRST_SARADC_P		253
#define SRST_TSADC_P		254
#define SRST_TSADC		255

#endif
