/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef _V4L2_CONTROLS_EXT_H
#define _V4L2_CONTROLS_EXT_H

#include <linux/amlogic/media/linuxtv-ext-ver.h>
#include <linux/v4l2-controls.h>

//
// User-class control Bases
//

#define V4L2_CID_USER_EXT_VSC_BASE (V4L2_CID_USER_BASE + 0x2000)
#define V4L2_CID_USER_EXT_CAPTURE_BASE (V4L2_CID_USER_BASE + 0x2100)
#define V4L2_CID_USER_EXT_PQ_BASE (V4L2_CID_USER_BASE + 0x3000)
#define V4L2_CID_USER_EXT_VBE_BASE (V4L2_CID_USER_BASE + 0x4000)
#define V4L2_CID_USER_EXT_HDMI_BASE (V4L2_CID_USER_BASE + 0x5000)
#define V4L2_CID_USER_EXT_ADC_BASE (V4L2_CID_USER_BASE + 0x6000)
#define V4L2_CID_USER_EXT_AVD_BASE (V4L2_CID_USER_BASE + 0x7000)
#define V4L2_CID_USER_EXT_VDEC_BASE (V4L2_CID_USER_BASE + 0x8000)
// 0x9000 is being used by FE: see v4l2-ext-frontend.h
#define V4L2_CID_USER_EXT_GPSCALER_BASE (V4L2_CID_USER_BASE + 0xA000)
#define V4L2_CID_USER_EXT_EARC_BASE (V4L2_CID_USER_BASE + 0xB000)
#define V4L2_CID_USER_EXT_VBI_BASE (V4L2_CID_USER_BASE + 0xC000)

//
// Scaler class control IDs
//

#define V4L2_CID_EXT_VSC_WIN_REGION (V4L2_CID_USER_EXT_VSC_BASE + 0)

#define V4L2_CID_EXT_VSC_FREEZE (V4L2_CID_USER_EXT_VSC_BASE + 1)

#define V4L2_CID_EXT_VSC_WIN_PROP (V4L2_CID_USER_EXT_VSC_BASE + 2)

#define V4L2_CID_EXT_VSC_PATTERN (V4L2_CID_USER_EXT_VSC_BASE + 3)
enum v4l2_ext_vsc_pattern {
	V4L2_EXT_VSC_PATTERN_OFF = 0,
	V4L2_EXT_VSC_PATTERN_MUX,
	V4L2_EXT_VSC_PATTERN_DI_NR,
	V4L2_EXT_VSC_PATTERN_SCALER,
	V4L2_EXT_VSC_PATTERN_MEMC,
	V4L2_EXT_VSC_PATTERN_DISPLAY,
	V4L2_EXT_VSC_PATTERN_RESERVED0,
	V4L2_EXT_VSC_PATTERN_RESERVED1,
	V4L2_EXT_VSC_PATTERN_RESERVED2,
	V4L2_EXT_VSC_PATTERN_RESERVED3
};

#define V4L2_CID_EXT_VSC_FRAME_DELAY (V4L2_CID_USER_EXT_VSC_BASE + 4)

#define V4L2_CID_EXT_VSC_ZORDER (V4L2_CID_USER_EXT_VSC_BASE + 5)

#define V4L2_CID_EXT_VSC_LIMITED_WIN_RATIO (V4L2_CID_USER_EXT_VSC_BASE + 6)

#define V4L2_CID_EXT_VSC_LATENCY_PATTERN (V4L2_CID_USER_EXT_VSC_BASE + 7)

#define V4L2_CID_EXT_VSC_ADAPTIVE_STREAM (V4L2_CID_USER_EXT_VSC_BASE + 8)

#define V4L2_CID_EXT_VSC_RGB444 (V4L2_CID_USER_EXT_VSC_BASE + 9)

#define V4L2_CID_EXT_VSC_VDO_MODE (V4L2_CID_USER_EXT_VSC_BASE + 10)

#define V4L2_CID_EXT_VSC_HDR_TYPE (V4L2_CID_USER_EXT_VSC_BASE + 11)

enum v4l2_ext_vsc_hdr_type {
	V4L2_EXT_VSC_HDR_TYPE_SDR = 0,
	V4L2_EXT_VSC_HDR_TYPE_HDR10,
	V4L2_EXT_VSC_HDR_TYPE_DOLBY,
	V4L2_EXT_VSC_HDR_TYPE_HLG,
	V4L2_EXT_VSC_HDR_TYPE_PRIME,
	V4L2_EXT_VSC_HDR_TYPE_DOLBY_LL,
	V4L2_EXT_VSC_HDR_TYPE_DOLBY_RF,
	V4L2_EXT_VSC_HDR_TYPE_HDR_RESERVED2,
	V4L2_EXT_VSC_HDR_TYPE_HDR_RESERVED3
};

#define V4L2_CID_EXT_VSC_CONNECT_INFO (V4L2_CID_USER_EXT_VSC_BASE + 12)

#define V4L2_CID_EXT_VSC_ACTIVE_WIN_INFO (V4L2_CID_USER_EXT_VSC_BASE + 13)

#define V4L2_CID_EXT_VSC_FREEZE_FRAME_BUFFER (V4L2_CID_USER_EXT_VSC_BASE + 14)

#define V4L2_CID_EXT_VSC_READ_FRAME_BUFFER_INFO                                \
	(V4L2_CID_USER_EXT_VSC_BASE + 15)

#define V4L2_CID_EXT_VSC_OCCUPATION_SUB_SCALER (V4L2_CID_USER_EXT_VSC_BASE + 16)

#define V4L2_CID_EXT_VSC_ORBIT_WINDOW (V4L2_CID_USER_EXT_VSC_BASE + 17)

#define V4L2_CID_EXT_VSC_ORBIT_MOVE (V4L2_CID_USER_EXT_VSC_BASE + 18)

//
// VSC class subscription IDs
//
#define V4L2_CID_EXT_VSC_SUBSCRIBE_MUTE_OFF (V4L2_CID_USER_EXT_VSC_BASE + 30)

#define V4L2_CID_EXT_VSC_SUBSCRIBE_ACTIVE_WIN (V4L2_CID_USER_EXT_VSC_BASE + 32)

#define V4L2_CID_EXT_VSC_CLEAR_SUBSCRIBE_MUTE_OFF                              \
	(V4L2_CID_USER_EXT_VSC_BASE + 31)

#define V4L2_CID_EXT_VSC_CLEAR_SUBSCRIBE_ACTIVE_WIN                            \
	(V4L2_CID_USER_EXT_VSC_BASE + 33)

#define V4L2_CID_EXT_VSC_SUBSCRIBE_APPLYING_DONE_WINDOW_REGION                 \
	(V4L2_CID_USER_EXT_VSC_BASE + 34)

#define V4L2_CID_EXT_VSC_SUBSCRIBE_ADAPTIVE_STREAM_AR_INFORMATION              \
	(V4L2_CID_USER_EXT_VSC_BASE + 35)

#define V4L2_CID_EXT_VSC_SUBSCRIBE_BSP_ERROR (V4L2_CID_USER_EXT_VSC_BASE + 36)

#define V4L2_CID_EXT_VSC_SUBSCRIBE_VIDEO_DELAY (V4L2_CID_USER_EXT_VSC_BASE + 37)

//
// VSC class subscription types
//

#define V4L2_EVENT_PRIVATE_EXT_VSC_BASE (V4L2_EVENT_PRIVATE_START + 0x2000)
#define V4L2_EVENT_PRIVATE_EXT_VSC_EVENT (V4L2_EVENT_PRIVATE_EXT_VSC_BASE + 1)

/* PQ class control IDs */
#define V4L2_CID_EXT_LED_BASE (V4L2_CID_USER_EXT_PQ_BASE)

#define V4L2_CID_EXT_LED_INIT (V4L2_CID_EXT_LED_BASE + 0)

#define V4L2_CID_EXT_LED_DB_IDX (V4L2_CID_EXT_LED_BASE + 1)

#define V4L2_CID_EXT_LED_DEMOMODE (V4L2_CID_EXT_LED_BASE + 2)

#define V4L2_CID_EXT_LED_EN (V4L2_CID_EXT_LED_BASE + 3)

#define V4L2_CID_EXT_LED_FIN (V4L2_CID_EXT_LED_BASE + 4)

#define V4L2_CID_EXT_LED_DB_DATA (V4L2_CID_EXT_LED_BASE + 5)

#define V4L2_CID_EXT_LED_CONTROL_SPI (V4L2_CID_EXT_LED_BASE + 6)

#define V4L2_CID_EXT_LED_APL_DATA (V4L2_CID_EXT_LED_BASE + 7)

#define V4L2_CID_EXT_LED_BPL_DATA (V4L2_CID_EXT_LED_BASE + 8)

#define V4L2_CID_EXT_MEMC_BASE (V4L2_CID_USER_EXT_PQ_BASE + 0x100)

#define V4L2_CID_EXT_MEMC_INIT (V4L2_CID_EXT_MEMC_BASE + 0)

#define V4L2_CID_EXT_MEMC_LOW_DELAY_MODE (V4L2_CID_EXT_MEMC_BASE + 1)

#define V4L2_CID_EXT_MEMC_MOTION_COMP (V4L2_CID_EXT_MEMC_BASE + 2)

#define V4L2_CID_EXT_MEMC_MOTION_PRO (V4L2_CID_EXT_MEMC_BASE + 3)

#define V4L2_CID_EXT_HDR_BASE (V4L2_CID_USER_EXT_PQ_BASE + 0x200)

#define V4L2_CID_EXT_HDR_INV_GAMMA (V4L2_CID_EXT_HDR_BASE + 0)

#define V4L2_CID_EXT_HDR_PIC_INFO (V4L2_CID_EXT_HDR_BASE + 1)

#define V4L2_CID_EXT_HDR_3DLUT (V4L2_CID_EXT_HDR_BASE + 2)

#define V4L2_CID_EXT_HDR_EOTF (V4L2_CID_EXT_HDR_BASE + 3)

#define V4L2_CID_EXT_HDR_OETF (V4L2_CID_EXT_HDR_BASE + 4)

#define V4L2_CID_EXT_HDR_TONEMAP (V4L2_CID_EXT_HDR_BASE + 5)

#define V4L2_CID_EXT_HDR_COLOR_CORRECTION (V4L2_CID_EXT_HDR_BASE + 6)

#define V4L2_CID_EXT_HDR_HLG_Y_GAIN_TBL (V4L2_CID_EXT_HDR_BASE + 7)

#define V4L2_CID_EXT_DOLBY_BASE (V4L2_CID_USER_EXT_PQ_BASE + 0x300)

#define V4L2_CID_EXT_DOLBY_CFG_PATH (V4L2_CID_EXT_DOLBY_BASE + 0)

#define V4L2_CID_EXT_DOLBY_PICTURE_MODE (V4L2_CID_EXT_DOLBY_BASE + 1)

#define V4L2_CID_EXT_DOLBY_PICTURE_MENU (V4L2_CID_EXT_DOLBY_BASE + 2)

#define V4L2_CID_EXT_DOLBY_SW_VERSION (V4L2_CID_EXT_DOLBY_BASE + 3)

#define V4L2_CID_EXT_DOLBY_PWM_RATIO (V4L2_CID_EXT_DOLBY_BASE + 4)

#define V4L2_CID_EXT_DOLBY_GD_DELAY (V4L2_CID_EXT_DOLBY_BASE + 5)

#define V4L2_CID_EXT_DOLBY_AMBIENT_LIGHT (V4L2_CID_EXT_DOLBY_BASE + 6)

#define V4L2_CID_EXT_DOLBY_CONTENTS_TYPE (V4L2_CID_EXT_DOLBY_BASE + 7)

#define V4L2_CID_EXT_VPQ_BASE (V4L2_CID_USER_EXT_PQ_BASE + 0x400)

#define V4L2_CID_EXT_VPQ_INIT (V4L2_CID_EXT_VPQ_BASE + 0)

#define V4L2_CID_EXT_VPQ_PICTURE_CTRL (V4L2_CID_EXT_VPQ_BASE + 1)

#define V4L2_CID_EXT_VPQ_SHARPNESS (V4L2_CID_EXT_VPQ_BASE + 2)

#define V4L2_CID_EXT_VPQ_HISTO_DATA (V4L2_CID_EXT_VPQ_BASE + 3)

#define V4L2_CID_EXT_VPQ_DYNAMIC_CONTRAST (V4L2_CID_EXT_VPQ_BASE + 4)

#define V4L2_CID_EXT_VPQ_DYNAMIC_CONTRAST_LUT (V4L2_CID_EXT_VPQ_BASE + 5)

#define V4L2_CID_EXT_VPQ_CM_DB_DATA (V4L2_CID_EXT_VPQ_BASE + 6)

#define V4L2_CID_EXT_VPQ_NOISE_REDUCTION (V4L2_CID_EXT_VPQ_BASE + 7)

#define V4L2_CID_EXT_VPQ_MPEG_NOISE_REDUCTION (V4L2_CID_EXT_VPQ_BASE + 8)

#define V4L2_CID_EXT_VPQ_BYPASS_BLOCK (V4L2_CID_EXT_VPQ_BASE + 9)

#define V4L2_CID_EXT_VPQ_BLACK_LEVEL (V4L2_CID_EXT_VPQ_BASE + 10)

#define V4L2_CID_EXT_VPQ_GAMMA_DATA (V4L2_CID_EXT_VPQ_BASE + 11)

#define V4L2_CID_EXT_VPQ_SUPER_RESOLUTION (V4L2_CID_EXT_VPQ_BASE + 12)

#define V4L2_CID_EXT_VPQ_NOISE_LEVEL (V4L2_CID_EXT_VPQ_BASE + 13)

#define V4L2_CID_EXT_VPQ_LOW_DELAY_MODE (V4L2_CID_EXT_VPQ_BASE + 14)

#define V4L2_CID_EXT_VPQ_DYNAMIC_CONTRAST_BYPASS_LUT (V4L2_CID_EXT_VPQ_BASE + 15)

#define V4L2_CID_EXT_VPQ_DYNAMIC_CONTRAST_COLOR_GAIN (V4L2_CID_EXT_VPQ_BASE + 16)

#define V4L2_CID_EXT_VPQ_TESTPATTERN (V4L2_CID_EXT_VPQ_BASE + 17)

#define V4L2_CID_EXT_VPQ_COLORTEMP_DATA (V4L2_CID_EXT_VPQ_BASE + 18)

#define V4L2_CID_EXT_VPQ_REAL_CINEMA (V4L2_CID_EXT_VPQ_BASE + 19)

#define V4L2_CID_EXT_VPQ_GAMUT_3DLUT (V4L2_CID_EXT_VPQ_BASE + 20)

#define V4L2_CID_EXT_VPQ_OD_TABLE (V4L2_CID_EXT_VPQ_BASE + 21)

#define V4L2_CID_EXT_VPQ_OD_EXTENSION (V4L2_CID_EXT_VPQ_BASE + 22)

#define V4L2_CID_EXT_VPQ_LOCALCONTRAST_TABLE (V4L2_CID_EXT_VPQ_BASE + 23)

#define V4L2_CID_EXT_VPQ_LOCALCONTRAST_DATA (V4L2_CID_EXT_VPQ_BASE + 24)

#define V4L2_CID_EXT_VPQ_PSP (V4L2_CID_EXT_VPQ_BASE + 25)

#define V4L2_CID_EXT_VPQ_GAMUT_MATRIX_PRE (V4L2_CID_EXT_VPQ_BASE + 26)

#define V4L2_CID_EXT_VPQ_GAMUT_MATRIX_POST (V4L2_CID_EXT_VPQ_BASE + 27)

#define V4L2_CID_EXT_VPQ_PQ_MODE_INFO (V4L2_CID_EXT_VPQ_BASE + 28)
#define V4L2_CID_EXT_VPQ_DEGAMMA_DATA (V4L2_CID_EXT_VPQ_BASE + 29)

#define V4L2_CID_EXT_VPQ_LUMINANCE_BOOST (V4L2_CID_EXT_VPQ_BASE + 30)

#define V4L2_CID_EXT_VPQ_OBC_DATA (V4L2_CID_EXT_VPQ_BASE + 31)

#define V4L2_CID_EXT_VPQ_OBC_LUT (V4L2_CID_EXT_VPQ_BASE + 32)

#define V4L2_CID_EXT_VPQ_OBC_CTRL (V4L2_CID_EXT_VPQ_BASE + 33)

#define V4L2_CID_EXT_VPQ_DECONTOUR (V4L2_CID_EXT_VPQ_BASE + 34)

#define V4L2_CID_EXT_VPQ_EXTRA_PATTERN (V4L2_CID_EXT_VPQ_BASE + 35)

#define V4L2_CID_EXT_VPQ_STEREO_FACE_CTRL (V4L2_CID_EXT_VPQ_BASE + 36)

#define V4L2_CID_EXT_VPQ_VIDEO_LATENCY (V4L2_CID_EXT_VPQ_BASE + 37)

#define V4L2_CID_EXT_VPQ_DB_DATA (V4L2_CID_EXT_VPQ_BASE + 38)

#define V4L2_CID_EXT_VPQ_SUBSCRIBE_VIDEO_LATENCY (V4L2_CID_EXT_VPQ_BASE + 39)

#define V4L2_CID_EXT_VPQ_PHDR_APL_GAIN_LUT (V4L2_CID_EXT_VPQ_BASE + 40)

#define V4L2_CID_EXT_AIPQ_BASE (V4L2_CID_USER_EXT_PQ_BASE + 0x500)

#define V4L2_CID_EXT_AIPQ_SQM_MODE (V4L2_CID_EXT_AIPQ_BASE + 0)

#define V4L2_CID_EXT_AIPQ_SR_MODE (V4L2_CID_EXT_AIPQ_BASE + 1)

#define V4L2_CID_EXT_AIPQ_DEPTH_MODE (V4L2_CID_EXT_AIPQ_BASE + 2)

#define V4L2_CID_EXT_AIPQ_SCENE_MODE (V4L2_CID_EXT_AIPQ_BASE + 3)

#define V4L2_CID_EXT_AIPQ_SCENE_INFO (V4L2_CID_EXT_AIPQ_BASE + 4)

#define V4L2_CID_EXT_AIPQ_GENRE_MODE (V4L2_CID_EXT_AIPQ_BASE + 5)

#define V4L2_CID_EXT_AIPQ_GENRE_INFO (V4L2_CID_EXT_AIPQ_BASE + 6)

#define V4L2_CID_EXT_VPQ_VIDEO_PATTERN_INFO (V4L2_CID_USER_EXT_PQ_BASE + 0x601)

/* VBE class control IDs */
#define V4L2_CID_EXT_VBE_BASE (V4L2_CID_USER_EXT_VBE_BASE)

#define V4L2_CID_EXT_VBE_INIT (V4L2_CID_EXT_VBE_BASE + 0)

#define V4L2_CID_EXT_VBE_RESUME (V4L2_CID_EXT_VBE_BASE + 1)

#define V4L2_CID_EXT_VBE_DISPLAYOUTPUT (V4L2_CID_EXT_VBE_BASE + 2)

#define V4L2_CID_EXT_VBE_MUTE (V4L2_CID_EXT_VBE_BASE + 3)

#define V4L2_CID_EXT_VBE_SSC (V4L2_CID_EXT_VBE_BASE + 4)

#define V4L2_CID_EXT_VBE_MIRROR (V4L2_CID_EXT_VBE_BASE + 5)

#define V4L2_CID_EXT_VBE_MPLUS_BOEBYPASS (V4L2_CID_EXT_VBE_BASE + 6)

#define V4L2_CID_EXT_VBE_MPLUS_MODE (V4L2_CID_EXT_VBE_BASE + 7)

#define V4L2_CID_EXT_VBE_DGA4CH (V4L2_CID_EXT_VBE_BASE + 8)

#define V4L2_CID_EXT_VBE_MPLUS_PARAM (V4L2_CID_EXT_VBE_BASE + 9)

#define V4L2_CID_EXT_VBE_INNER_PATTERN (V4L2_CID_EXT_VBE_BASE + 10)

#define V4L2_CID_EXT_VBE_TSCIC (V4L2_CID_EXT_VBE_BASE + 11)

#define V4L2_CID_EXT_VBE_EPI_SCRAMBLE (V4L2_CID_EXT_VBE_BASE + 12)

#define V4L2_CID_EXT_VBE_EPI_10BIT (V4L2_CID_EXT_VBE_BASE + 13)

#define V4L2_CID_EXT_VBE_MPLUS_DATA (V4L2_CID_EXT_VBE_BASE + 14)

#define V4L2_CID_EXT_VBE_PWM_APPLY_PARAM (V4L2_CID_EXT_VBE_BASE + 15)

#define V4L2_CID_EXT_VBE_PWM_PARAM (V4L2_CID_EXT_VBE_BASE + 16)

#define V4L2_CID_EXT_VBE_PWM_INIT (V4L2_CID_EXT_VBE_BASE + 17)

#define V4L2_CID_EXT_VBE_VCOM_PAT_DRAW (V4L2_CID_EXT_VBE_BASE + 18)

#define V4L2_CID_EXT_VBE_VCOM_PAT_CTRL (V4L2_CID_EXT_VBE_BASE + 19)

#define V4L2_CID_EXT_VBE_PWM_SET_DUTY (V4L2_CID_EXT_VBE_BASE + 20)

#define V4L2_CID_EXT_VBE_ORBIT (V4L2_CID_EXT_VBE_BASE + 21)

#define V4L2_CID_EXT_VBE_LSR (V4L2_CID_EXT_VBE_BASE + 22)

#define V4L2_CID_EXT_VBE_CPC (V4L2_CID_EXT_VBE_BASE + 23)

#define V4L2_CID_EXT_VBE_GSR (V4L2_CID_EXT_VBE_BASE + 24)

#define V4L2_CID_EXT_VBE_OSD_GAIN (V4L2_CID_EXT_VBE_BASE + 25)

#define V4L2_CID_EXT_VBE_ALPHA_OSD (V4L2_CID_EXT_VBE_BASE + 26)

#define V4L2_CID_EXT_VBE_GSR_STATUS (V4L2_CID_EXT_VBE_BASE + 27)

#define V4L2_CID_EXT_VBE_LOCK_STATUS (V4L2_CID_EXT_VBE_BASE + 28)

#define V4L2_CID_EXT_VBE_DEMURA (V4L2_CID_EXT_VBE_BASE + 29)

#define V4L2_CID_EXT_VBE_PCLRC (V4L2_CID_EXT_VBE_BASE + 30)

#define V4L2_CID_EXT_VBE_DISPLAYOUTPUT_5060HZ (V4L2_CID_EXT_VBE_BASE + 31)

//
// GSR_STRESS_COUNT control ID
//
#define V4L2_CID_EXT_VBE_GSR_STRESS_COUNT (V4L2_CID_EXT_VBE_BASE + 32)

//
// SET GSR2 control ID
//
#define V4L2_CID_EXT_VBE_GSR2 (V4L2_CID_EXT_VBE_BASE + 33)

//
// SET IRRAdaptedLum control ID
//
#define V4L2_CID_EXT_VBE_IRR_ADAPTEDLUM (V4L2_CID_EXT_VBE_BASE + 34)

//
// GET IRR RISK control ID
//
#define V4L2_CID_EXT_VBE_IRR_RESULT (V4L2_CID_EXT_VBE_BASE + 35)

//
// HDMI class control IDs
//

#define V4L2_CID_EXT_HDMI_TIMING_INFO (V4L2_CID_USER_EXT_HDMI_BASE + 0)

#define V4L2_CID_EXT_HDMI_DRM_INFO (V4L2_CID_USER_EXT_HDMI_BASE + 1)

#define V4L2_CID_EXT_HDMI_VSI_INFO (V4L2_CID_USER_EXT_HDMI_BASE + 2)

#define V4L2_CID_EXT_HDMI_SPD_INFO (V4L2_CID_USER_EXT_HDMI_BASE + 3)

#define V4L2_CID_EXT_HDMI_AVI_INFO (V4L2_CID_USER_EXT_HDMI_BASE + 4)

#define V4L2_CID_EXT_HDMI_PACKET_INFO (V4L2_CID_USER_EXT_HDMI_BASE + 5)

#define V4L2_CID_EXT_HDMI_DOLBY_HDR (V4L2_CID_USER_EXT_HDMI_BASE + 6)

#define V4L2_CID_EXT_HDMI_EDID (V4L2_CID_USER_EXT_HDMI_BASE + 7)

#define V4L2_CID_EXT_HDMI_CONNECTION_STATE (V4L2_CID_USER_EXT_HDMI_BASE + 8)

#define V4L2_CID_EXT_HDMI_HPD (V4L2_CID_USER_EXT_HDMI_BASE + 9)

#define V4L2_CID_EXT_HDMI_POWER_OFF (V4L2_CID_USER_EXT_HDMI_BASE + 10)

#define V4L2_CID_EXT_HDMI_HDCP_KEY (V4L2_CID_USER_EXT_HDMI_BASE + 11)

#define V4L2_CID_EXT_HDMI_DISCONNECT (V4L2_CID_USER_EXT_HDMI_BASE + 12)

#define V4L2_CID_EXT_HDMI_VRR_FREQUENCY (V4L2_CID_USER_EXT_HDMI_BASE + 13)

#define V4L2_CID_EXT_HDMI_EMP_INFO (V4L2_CID_USER_EXT_HDMI_BASE + 14)

#define V4L2_CID_EXT_HDMI_HDCP_REPEATER (V4L2_CID_USER_EXT_HDMI_BASE + 15)

#define V4L2_CID_EXT_HDMI_OVERRIDE_EOTF (V4L2_CID_USER_EXT_HDMI_BASE + 16)

#define V4L2_CID_EXT_HDMI_QUERYCAP (V4L2_CID_USER_EXT_HDMI_BASE + 17)

#define V4L2_CID_EXT_HDMI_HPD_LOW_DURATION_DC_ON (V4L2_CID_USER_EXT_HDMI_BASE + 18)

#define V4L2_CID_EXT_HDMI_HDCP_REPEATER_TOPOLOGY (V4L2_CID_USER_EXT_HDMI_BASE + 19)

#define V4L2_CID_EXT_HDMI_HDCP_REPEATER_STREAM_MANAGE (V4L2_CID_USER_EXT_HDMI_BASE + 20)

#define V4L2_CID_EXT_HDMI_SLEEP (V4L2_CID_USER_EXT_HDMI_BASE + 21)

/* HDMI diagnostics class control IDs */
#define V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE (V4L2_CID_USER_EXT_HDMI_BASE + 0x100)

#define V4L2_CID_EXT_HDMI_DIAGNOSTICS_STATUS (V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE + 0)

#define V4L2_CID_EXT_HDMI_PHY_STATUS (V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE + 1)

#define V4L2_CID_EXT_HDMI_LINK_STATUS (V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE + 2)

#define V4L2_CID_EXT_HDMI_VIDEO_STATUS (V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE + 3)

#define V4L2_CID_EXT_HDMI_AUDIO_STATUS (V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE + 4)

#define V4L2_CID_EXT_HDMI_HDCP_STATUS (V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE + 5)

#define V4L2_CID_EXT_HDMI_SCDC_STATUS (V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE + 6)

#define V4L2_CID_EXT_HDMI_ERROR_STATUS (V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE + 7)

#define V4L2_CID_EXT_HDMI_EXPERT_SETTING (V4L2_CID_EXT_HDMI_DIAGNOSTICS_BASE + 8)

//
// ADC class control IDs
//

#define V4L2_CID_EXT_ADC_TIMING_INFO (V4L2_CID_USER_EXT_ADC_BASE + 0)

#define V4L2_CID_EXT_ADC_OTP_DATA (V4L2_CID_USER_EXT_ADC_BASE + 1)

#define V4L2_CID_EXT_ADC_CALIBRATION_DATA (V4L2_CID_USER_EXT_ADC_BASE + 2)

#define V4L2_CID_EXT_ADC_CALIBRATION_TYPE (V4L2_CID_USER_EXT_ADC_BASE + 3)
enum v4l2_ext_adc_calibration_type {
	V4L2_EXT_ADC_CALIBRATION_TYPE_OTP = 0,
	V4L2_EXT_ADC_CALIBRATION_TYPE_EXTERNAL,
	V4L2_EXT_ADC_CALIBRATION_TYPE_INTERNAL,
	V4L2_EXT_ADC_CALIBRATION_TYPE_USER,
};

#define V4L2_CID_EXT_ADC_RESET_CALIBRATION (V4L2_CID_USER_EXT_ADC_BASE + 4)

#define V4L2_CID_EXT_ADC_FAST_SWITCH (V4L2_CID_USER_EXT_ADC_BASE + 5)

//
// AVD class control IDs
//

#define V4L2_CID_EXT_AVD_PORT (V4L2_CID_USER_EXT_AVD_BASE + 0)

#define V4L2_CID_EXT_AVD_TIMING_INFO (V4L2_CID_USER_EXT_AVD_BASE + 1)

#define V4L2_CID_EXT_AVD_VIDEO_SYNC (V4L2_CID_USER_EXT_AVD_BASE + 2)

#define V4L2_CID_EXT_AVD_AUTO_TUNING_MODE (V4L2_CID_USER_EXT_AVD_BASE + 3)

#define V4L2_CID_EXT_AVD_CHANNEL_CHANGE (V4L2_CID_USER_EXT_AVD_BASE + 4)

//
// VBI class control IDs
//

#define V4L2_CID_EXT_VBI_COPY_PROTECTION_INFO (V4L2_CID_USER_EXT_VBI_BASE + 0)

#define V4L2_CID_EXT_VBI_FLUSH (V4L2_CID_USER_EXT_VBI_BASE + 1)

/* VDEC class control IDs */
#define V4L2_CID_EXT_VDEC_BASE (V4L2_CID_USER_EXT_VDEC_BASE + 0x0)

#define V4L2_CID_EXT_VDEC_CHANNEL (V4L2_CID_EXT_VDEC_BASE + 1)

#define V4L2_CID_EXT_VDEC_VTP_PORT (V4L2_CID_EXT_VDEC_BASE + 2) // Deprecated, Not use

#define V4L2_CID_EXT_VDEC_RESETTING (V4L2_CID_EXT_VDEC_BASE + 3)
// Deprecated, change to V4L2_CID_EXT_VDO_BASE cmd id
#define V4L2_CID_EXT_VDEC_VDO_PORT (V4L2_CID_EXT_VDEC_BASE + 4)

#define V4L2_CID_EXT_VDEC_AV_SYNC (V4L2_CID_EXT_VDEC_BASE + 5)

#define V4L2_CID_EXT_VDEC_FRAME_ADVANCE (V4L2_CID_EXT_VDEC_BASE + 6)

#define V4L2_CID_EXT_VDEC_DECODING_SPEED (V4L2_CID_EXT_VDEC_BASE + 7)

#define V4L2_CID_EXT_VDEC_DECODE_MODE (V4L2_CID_EXT_VDEC_BASE + 8)

#define V4L2_CID_EXT_VDEC_FREEZE_MODE (V4L2_CID_EXT_VDEC_BASE + 9)

#define V4L2_CID_EXT_VDEC_DECODER_VERSION (V4L2_CID_EXT_VDEC_BASE + 10)
#define V4L2_CID_EXT_VDEC_KR_DUAL_3D_MODE                                      \
	(V4L2_CID_EXT_VDEC_BASE + 11) // Deprecated

#define V4L2_CID_EXT_VDEC_STC_MODE (V4L2_CID_EXT_VDEC_BASE + 12)

#define V4L2_CID_EXT_VDEC_AUDIO_CHANNEL (V4L2_CID_EXT_VDEC_BASE + 13)

#define V4L2_CID_EXT_VDEC_DISPLAY_DELAY (V4L2_CID_EXT_VDEC_BASE + 14)

#define V4L2_CID_EXT_VDEC_LIPSYNC_MASTER (V4L2_CID_EXT_VDEC_BASE + 15)

#define V4L2_CID_EXT_VDEC_VSYNC_THRESHOLD (V4L2_CID_EXT_VDEC_BASE + 16)

#define V4L2_CID_EXT_VDEC_PVR_MODE (V4L2_CID_EXT_VDEC_BASE + 17)

#define V4L2_CID_EXT_VDEC_FAST_IFRAME_MODE (V4L2_CID_EXT_VDEC_BASE + 18)

#define V4L2_CID_EXT_VDEC_HFR_TYPE (V4L2_CID_EXT_VDEC_BASE + 19)

#define V4L2_CID_EXT_VDEC_TEMPORAL_ID_MAX (V4L2_CID_EXT_VDEC_BASE + 20)

#define V4L2_CID_EXT_VDEC_DIRECT_MODE (V4L2_CID_EXT_VDEC_BASE + 21)

#define V4L2_CID_EXT_VDEC_DRIPDEC_MODE                                         \
	(V4L2_CID_EXT_VDEC_BASE + 22) // To support MHEG certification

#define V4L2_CID_EXT_VDEC_ECP_INFO_NOTI                                        \
	(V4L2_CID_EXT_VDEC_BASE + 23) // To support DVB - ECP set

#define V4L2_CID_EXT_VDEC_ECP_OFFSET                                           \
	(V4L2_CID_EXT_VDEC_BASE + 24) // To support DVB - ECP get

#define V4L2_CID_EXT_VDEC_ECP_SIZE                                             \
	(V4L2_CID_EXT_VDEC_BASE + 25) // To support DVB - ECP get

/* VDEC class EXT control IDs */

#define V4L2_CID_EXT_VDEC_USER_EVENT_DATA (V4L2_CID_EXT_VDEC_BASE + 101)

#define V4L2_CID_EXT_VDEC_PICINFO_EVENT_DATA (V4L2_CID_EXT_VDEC_BASE + 102)

#define V4L2_CID_EXT_VDEC_DECODER_STATUS (V4L2_CID_EXT_VDEC_BASE + 103)

#define V4L2_CID_EXT_VDEC_STREAM_INFO (V4L2_CID_EXT_VDEC_BASE + 104)

#define V4L2_CID_EXT_VDEC_DIRECT_ESDATA (V4L2_CID_EXT_VDEC_BASE + 105)

#define V4L2_CID_EXT_VDEC_VIDEO_INFO (V4L2_CID_EXT_VDEC_BASE + 106)

#define V4L2_CID_EXT_VDEC_PICINFO_EVENT_DATA_EXT                               \
	(V4L2_CID_EXT_VDEC_BASE + 107) // To support HFR, frame rate fraction type
	// structure is added. and useless member
	// variable is deleted.

// To support MHEG certification, Pass I-frame buffer information
#define V4L2_CID_EXT_VDEC_DRIPDEC_PICTURE		 (V4L2_CID_EXT_VDEC_BASE + 108)
#define V4L2_CID_EXT_VDEC_DECODED_PICTURE_BUFFER (V4L2_CID_EXT_VDEC_BASE + 109)
/* VDEC class subscription types */
#define V4L2_EVENT_PRIVATE_EXT_VDEC_BASE  (V4L2_EVENT_PRIVATE_START + 0x8000)
#define V4L2_EVENT_PRIVATE_EXT_VDEC_EVENT (V4L2_EVENT_PRIVATE_EXT_VDEC_BASE + 1)
/* VDEC class subscription event IDs */
#define V4L2_SUB_EXT_VDEC_BASE (0x8000)
#define V4L2_SUB_EXT_VDEC_FRAME (V4L2_SUB_EXT_VDEC_BASE + 1)
#define V4L2_SUB_EXT_VDEC_PICINFO (V4L2_SUB_EXT_VDEC_BASE + 2)
#define V4L2_SUB_EXT_VDEC_USERDATA (V4L2_SUB_EXT_VDEC_BASE + 3)
/* VDO class control ID */
#define V4L2_CID_EXT_VDO_BASE (V4L2_CID_USER_EXT_VDEC_BASE + 0x500)
#define V4L2_CID_EXT_VDO_VDEC_PORT (V4L2_CID_EXT_VDO_BASE + 1)
#define V4L2_CID_EXT_VDO_VDEC_CONNECTING (V4L2_CID_EXT_VDO_BASE + 2)
#define V4L2_CID_EXT_VDO_VDEC_DISCONNECTING (V4L2_CID_EXT_VDO_BASE + 3)
//
// videotexture class control IDs
//

#define V4L2_CID_EXT_CAPTURE_CAPABILITY_INFO                                   \
	(V4L2_CID_USER_EXT_CAPTURE_BASE + 0)

#define V4L2_CID_EXT_CAPTURE_PLANE_INFO (V4L2_CID_USER_EXT_CAPTURE_BASE + 1)

#define V4L2_CID_EXT_CAPTURE_VIDEO_WIN_INFO (V4L2_CID_USER_EXT_CAPTURE_BASE + 2)

#define V4L2_CID_EXT_CAPTURE_PLANE_PROP (V4L2_CID_USER_EXT_CAPTURE_BASE + 3)

#define V4L2_CID_EXT_CAPTURE_FREEZE_MODE (V4L2_CID_USER_EXT_CAPTURE_BASE + 4)

#define V4L2_CID_EXT_CAPTURE_DONE_USER_PROCESSING                              \
	(V4L2_CID_USER_EXT_CAPTURE_BASE + 5)

#define V4L2_CID_EXT_CAPTURE_PHYSICAL_MEMORY_INFO                              \
	(V4L2_CID_USER_EXT_CAPTURE_BASE + 6)

#define V4L2_CID_EXT_CAPTURE_OUTPUT_FRAMERATE                                  \
	(V4L2_CID_USER_EXT_CAPTURE_BASE + 7)

#define V4L2_CID_EXT_CAPTURE_DIVIDE_FRAMERATE                                  \
	(V4L2_CID_USER_EXT_CAPTURE_BASE + 8)

/* Capture class subscription IDs */
#define V4L2_CID_EXT_CAPTURE_SUBSCRIBE_FRAME_READY                             \
	(V4L2_CID_USER_EXT_CAPTURE_BASE + 30)

/* Capture class subscription types */
#define V4L2_EVENT_PRIVATE_EXT_CAPTURE_BASE (V4L2_EVENT_PRIVATE_START + 0x2100)
#define V4L2_EVENT_PRIVATE_EXT_CAPTURE_EVENT                                   \
	(V4L2_EVENT_PRIVATE_EXT_CAPTURE_BASE + 1)

/* Gpscaler class control IDs */
#define V4L2_CID_EXT_GPSCALER_MAX_FRAME_SIZE                                   \
	(V4L2_CID_USER_EXT_GPSCALER_BASE + 1)

#define V4L2_CID_EXT_GPSCALER_INPUT_FRAME_SIZE                                 \
	(V4L2_CID_USER_EXT_GPSCALER_BASE + 2)

#define V4L2_CID_EXT_GPSCALER_ACTIVE_REGION_DETECTION_MODE                     \
	(V4L2_CID_USER_EXT_GPSCALER_BASE + 3)

#define V4L2_CID_EXT_GPSCALER_ACTIVE_REGION_DETECTION_INFO_H                   \
	(V4L2_CID_USER_EXT_GPSCALER_BASE + 4)

#define V4L2_CID_EXT_GPSCALER_ACTIVE_REGION_DETECTION_INFO_V                   \
	(V4L2_CID_USER_EXT_GPSCALER_BASE + 5)

/* eARC class control IDs */
#define V4L2_CID_EXT_EARC (V4L2_CID_USER_EXT_EARC_BASE + 0)

#define V4L2_CID_EXT_EARC_CONNECTION_INFO (V4L2_CID_USER_EXT_EARC_BASE + 1)

#define V4L2_CID_EXT_EARC_SET_ERX_LATENCY_REQ (V4L2_CID_USER_EXT_EARC_BASE + 2)

#define V4L2_CID_EXT_EARC_RESET_HDMI_HPD_BIT (V4L2_CID_USER_EXT_EARC_BASE + 3)

#endif
