/* SPDX-License-Identifier: Apache-2.0 OR MIT */
/*
 * Copyright (c) 2015 Rockchip Electronics Co., Ltd.
 */

#ifndef __RK_VENC_CFG_H__
#define __RK_VENC_CFG_H__

#include "rk_type.h"
#include "mpp_err.h"

typedef void* MppEncCfg;

#ifdef __cplusplus
extern "C" {
#endif

/* legacy interface */
MPP_RET mpp_enc_cfg_init(MppEncCfg *cfg);
MPP_RET mpp_enc_cfg_deinit(MppEncCfg cfg);

/* new interface */
RK_S32 mpp_enc_cfg_get(MppEncCfg *cfg, const char *name, void *val);
RK_S32 mpp_enc_cfg_put(MppEncCfg cfg);

MPP_RET mpp_enc_cfg_set_s32(MppEncCfg cfg, const char *name, RK_S32 val);
MPP_RET mpp_enc_cfg_set_u32(MppEncCfg cfg, const char *name, RK_U32 val);
MPP_RET mpp_enc_cfg_set_s64(MppEncCfg cfg, const char *name, RK_S64 val);
MPP_RET mpp_enc_cfg_set_u64(MppEncCfg cfg, const char *name, RK_U64 val);
MPP_RET mpp_enc_cfg_set_ptr(MppEncCfg cfg, const char *name, void *val);
MPP_RET mpp_enc_cfg_set_st(MppEncCfg cfg, const char *name, void *val);

MPP_RET mpp_enc_cfg_get_s32(MppEncCfg cfg, const char *name, RK_S32 *val);
MPP_RET mpp_enc_cfg_get_u32(MppEncCfg cfg, const char *name, RK_U32 *val);
MPP_RET mpp_enc_cfg_get_s64(MppEncCfg cfg, const char *name, RK_S64 *val);
MPP_RET mpp_enc_cfg_get_u64(MppEncCfg cfg, const char *name, RK_U64 *val);
MPP_RET mpp_enc_cfg_get_ptr(MppEncCfg cfg, const char *name, void **val);
MPP_RET mpp_enc_cfg_get_st(MppEncCfg cfg, const char *name, void *val);

void mpp_enc_cfg_show(void);

#ifdef __cplusplus
}
#endif

#endif /*__RK_VENC_CFG_H__*/
