/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2018 Fuzhou Rockchip Electronics Co., Ltd
 */

#ifndef _DT_BINDINGS_DRAM_ROCKCHIP_RK1808_H
#define _DT_BINDINGS_DRAM_ROCKCHIP_RK1808_H

#define DDR2_DS_FULL			(0)
#define DDR2_DS_REDUCE			(1)

#define DDR2_ODT_DIS			(0)
#define DDR2_ODT_50ohm			(50)	/* optional */
#define DDR2_ODT_75ohm			(75)
#define DDR2_ODT_150ohm			(150)

#define DDR3_DS_34ohm			(34)
#define DDR3_DS_40ohm			(40)

#define DDR3_ODT_DIS			(0)
#define DDR3_ODT_40ohm			(40)
#define DDR3_ODT_60ohm			(60)
#define DDR3_ODT_120ohm			(120)

#define LP2_DS_34ohm			(34)
#define LP2_DS_40ohm			(40)
#define LP2_DS_48ohm			(48)
#define LP2_DS_60ohm			(60)
#define LP2_DS_68_6ohm			(68)	/* optional */
#define LP2_DS_80ohm			(80)
#define LP2_DS_120ohm			(120)	/* optional */

#define LP3_DS_34ohm			(34)
#define LP3_DS_40ohm			(40)
#define LP3_DS_48ohm			(48)
#define LP3_DS_60ohm			(60)
#define LP3_DS_80ohm			(80)
#define LP3_DS_34D_40U			(3440)
#define LP3_DS_40D_48U			(4048)
#define LP3_DS_34D_48U			(3448)

#define LP3_ODT_DIS			(0)
#define LP3_ODT_60ohm			(60)
#define LP3_ODT_120ohm			(120)
#define LP3_ODT_240ohm			(240)

#define LP4_PDDS_40ohm			(40)
#define LP4_PDDS_48ohm			(48)
#define LP4_PDDS_60ohm			(60)
#define LP4_PDDS_80ohm			(80)
#define LP4_PDDS_120ohm			(120)
#define LP4_PDDS_240ohm			(240)

#define LP4_DQ_ODT_40ohm		(40)
#define LP4_DQ_ODT_48ohm		(48)
#define LP4_DQ_ODT_60ohm		(60)
#define LP4_DQ_ODT_80ohm		(80)
#define LP4_DQ_ODT_120ohm		(120)
#define LP4_DQ_ODT_240ohm		(240)
#define LP4_DQ_ODT_DIS			(0)

#define LP4_CA_ODT_40ohm		(40)
#define LP4_CA_ODT_48ohm		(48)
#define LP4_CA_ODT_60ohm		(60)
#define LP4_CA_ODT_80ohm		(80)
#define LP4_CA_ODT_120ohm		(120)
#define LP4_CA_ODT_240ohm		(240)
#define LP4_CA_ODT_DIS			(0)

#define DDR4_DS_34ohm			(34)
#define DDR4_DS_48ohm			(48)
#define DDR4_RTT_NOM_DIS		(0)
#define DDR4_RTT_NOM_60ohm		(60)
#define DDR4_RTT_NOM_120ohm		(120)
#define DDR4_RTT_NOM_40ohm		(40)
#define DDR4_RTT_NOM_240ohm		(240)
#define DDR4_RTT_NOM_48ohm		(48)
#define DDR4_RTT_NOM_80ohm		(80)
#define DDR4_RTT_NOM_34ohm		(34)

#define PHY_DDR3_RON_DISABLE		(0)
#define PHY_DDR3_RON_340ohm		(1)
#define PHY_DDR3_RON_170ohm		(2)
#define PHY_DDR3_RON_113ohm		(3)
#define PHY_DDR3_RON_85ohm		(4)
#define PHY_DDR3_RON_68ohm		(5)
#define PHY_DDR3_RON_57ohm		(6)
#define PHY_DDR3_RON_49ohm		(7)
#define PHY_DDR3_RON_43ohm		(16)
#define PHY_DDR3_RON_38ohm		(17)
#define PHY_DDR3_RON_34ohm		(18)
#define PHY_DDR3_RON_31ohm		(19)
#define PHY_DDR3_RON_28ohm		(20)
#define PHY_DDR3_RON_26ohm		(21)
#define PHY_DDR3_RON_24ohm		(22)
#define PHY_DDR3_RON_23ohm		(23)
#define PHY_DDR3_RON_21ohm		(24)
#define PHY_DDR3_RON_20ohm		(25)
#define PHY_DDR3_RON_19ohm		(26)
#define PHY_DDR3_RON_18ohm		(27)
#define PHY_DDR3_RON_17ohm		(28)
#define PHY_DDR3_RON_16ohm		(29)
#define PHY_DDR3_RON_15ohm		(31)

#define PHY_DDR3_RTT_DISABLE		(0)
#define PHY_DDR3_RTT_852ohm		(1)
#define PHY_DDR3_RTT_427ohm		(2)
#define PHY_DDR3_RTT_284ohm		(3)
#define PHY_DDR3_RTT_213ohm		(4)
#define PHY_DDR3_RTT_171ohm		(5)
#define PHY_DDR3_RTT_142ohm		(6)
#define PHY_DDR3_RTT_122ohm		(7)
#define PHY_DDR3_RTT_107ohm		(16)
#define PHY_DDR3_RTT_95ohm		(17)
#define PHY_DDR3_RTT_85ohm		(18)
#define PHY_DDR3_RTT_78ohm		(19)
#define PHY_DDR3_RTT_71ohm		(20)
#define PHY_DDR3_RTT_66ohm		(21)
#define PHY_DDR3_RTT_61ohm		(22)
#define PHY_DDR3_RTT_57ohm		(23)
#define PHY_DDR3_RTT_53ohm		(24)
#define PHY_DDR3_RTT_50ohm		(25)
#define PHY_DDR3_RTT_47ohm		(26)
#define PHY_DDR3_RTT_45ohm		(27)
#define PHY_DDR3_RTT_43ohm		(28)
#define PHY_DDR3_RTT_41ohm		(29)
#define PHY_DDR3_RTT_39ohm		(30)
#define PHY_DDR3_RTT_37ohm		(31)

#define PHY_DDR4_LPDDR2_3_RON_DISABLE	(0)
#define PHY_DDR4_LPDDR2_3_RON_376ohm	(1)
#define PHY_DDR4_LPDDR2_3_RON_188ohm	(2)
#define PHY_DDR4_LPDDR2_3_RON_125ohm	(3)
#define PHY_DDR4_LPDDR2_3_RON_94ohm	(4)
#define PHY_DDR4_LPDDR2_3_RON_75ohm	(5)
#define PHY_DDR4_LPDDR2_3_RON_63ohm	(6)
#define PHY_DDR4_LPDDR2_3_RON_54ohm	(7)
#define PHY_DDR4_LPDDR2_3_RON_47ohm	(16)
#define PHY_DDR4_LPDDR2_3_RON_42ohm	(17)
#define PHY_DDR4_LPDDR2_3_RON_38ohm	(18)
#define PHY_DDR4_LPDDR2_3_RON_34ohm	(19)
#define PHY_DDR4_LPDDR2_3_RON_31ohm	(20)
#define PHY_DDR4_LPDDR2_3_RON_29ohm	(21)
#define PHY_DDR4_LPDDR2_3_RON_27ohm	(22)
#define PHY_DDR4_LPDDR2_3_RON_25ohm	(23)
#define PHY_DDR4_LPDDR2_3_RON_23ohm	(24)
#define PHY_DDR4_LPDDR2_3_RON_22ohm	(25)
#define PHY_DDR4_LPDDR2_3_RON_21ohm	(26)
#define PHY_DDR4_LPDDR2_3_RON_20ohm	(27)
#define PHY_DDR4_LPDDR2_3_RON_19ohm	(28)
#define PHY_DDR4_LPDDR2_3_RON_18ohm	(29)
#define PHY_DDR4_LPDDR2_3_RON_17ohm	(30)
#define PHY_DDR4_LPDDR2_3_RON_16ohm	(31)

#define PHY_DDR4_LPDDR2_3_RTT_DISABLE	(0)
#define PHY_DDR4_LPDDR2_3_RTT_915ohm	(1)
#define PHY_DDR4_LPDDR2_3_RTT_458ohm	(2)
#define PHY_DDR4_LPDDR2_3_RTT_305ohm	(3)
#define PHY_DDR4_LPDDR2_3_RTT_229ohm	(4)
#define PHY_DDR4_LPDDR2_3_RTT_183ohm	(5)
#define PHY_DDR4_LPDDR2_3_RTT_153ohm	(6)
#define PHY_DDR4_LPDDR2_3_RTT_131ohm	(7)
#define PHY_DDR4_LPDDR2_3_RTT_115ohm	(16)
#define PHY_DDR4_LPDDR2_3_RTT_102ohm	(17)
#define PHY_DDR4_LPDDR2_3_RTT_92ohm	(18)
#define PHY_DDR4_LPDDR2_3_RTT_83ohm	(19)
#define PHY_DDR4_LPDDR2_3_RTT_76ohm	(20)
#define PHY_DDR4_LPDDR2_3_RTT_70ohm	(21)
#define PHY_DDR4_LPDDR2_3_RTT_65ohm	(22)
#define PHY_DDR4_LPDDR2_3_RTT_61ohm	(23)
#define PHY_DDR4_LPDDR2_3_RTT_57ohm	(24)
#define PHY_DDR4_LPDDR2_3_RTT_54ohm	(25)
#define PHY_DDR4_LPDDR2_3_RTT_51ohm	(26)
#define PHY_DDR4_LPDDR2_3_RTT_48ohm	(27)
#define PHY_DDR4_LPDDR2_3_RTT_46ohm	(28)
#define PHY_DDR4_LPDDR2_3_RTT_44ohm	(29)
#define PHY_DDR4_LPDDR2_3_RTT_42ohm	(30)
#define PHY_DDR4_LPDDR2_3_RTT_40ohm	(31)

#endif /*_DT_BINDINGS_DRAM_ROCKCHIP_RK1808_H*/
